package gov.va.med.mhv.vitals.converter;

import gov.va.med.mhv.vitals.dto.BodyWeightReadingDTO;
import gov.va.med.mhv.vitals.model.BodyWeightReading;

import java.util.ArrayList;
import java.util.List;

public class BodyWeightConverter {
	
	public static BodyWeightReadingDTO  convertBWReadingDomain(BodyWeightReading bwReading ){
		BodyWeightReadingDTO dto = new BodyWeightReadingDTO();
		dto.setBodyweightID(bwReading.getId());
		dto.setComments(bwReading.getComments());
		dto.setBodyweightMeasure(bwReading.getBodyweightMeasure());
		dto.setBodyweight(bwReading.getBodyweight());
		dto.setReading(bwReading.getReading());
		dto.setUserprofileId(bwReading.getUserprofileId());
		return dto;
	}
	
	
	public static BodyWeightReading convertBWReadingDTO(BodyWeightReadingDTO bwReadingDTO){
		BodyWeightReading bwReading = new BodyWeightReading();
		bwReading.setComments(bwReadingDTO.getComments());
		bwReading.setId(bwReadingDTO.getBodyweightID());
		bwReading.setOplock(0);
		bwReading.setReading(bwReadingDTO.getReading());
		bwReading.setUserprofileId(bwReadingDTO.getUserprofileId());
		bwReading.setBodyweight(bwReadingDTO.getBodyweight());
		bwReading.setBodyweightMeasure(bwReadingDTO.getBodyweightMeasure());
		return bwReading;
	}
	
	
	public static List<BodyWeightReadingDTO>  convertBWReadings( List<BodyWeightReading> bwReadings ){
		List<BodyWeightReadingDTO> bwReadingDTOS = new ArrayList<BodyWeightReadingDTO>();
		for(BodyWeightReading bwReading : bwReadings){
			BodyWeightReadingDTO dto = convertBWReadingDomain(bwReading);
			bwReadingDTOS.add(dto);
		}
		return bwReadingDTOS;
	}


}
